
/*

    This program converts a TiVo TyStream into two elementry streams,
    one audio and one video, or to a single MPEG program stream.
    All source code is completely public domain.  It was written by
    me (Charlie Payne).  While insight was taken from ExtractStream
    and ConvertStream, no actual code was.  Some convertion
    concepts were borrowed, others are new.

    At this time nobody outside of TiVo completely understands the
    TyStream format.  Because of this, much of the decoding is based
    on assumptions which may prove - in time - to be incorrect.  This
    should be an ongoing project.  I encourage people to continue it.

*/



#define VIDEO_ID        0xE0
#define AUDIO_ID        0xC0
#define AUDIO_PES       3
#define VIDEO_PES       6
#define VIDEO_HEADER    7
#define CHUNK_SIZE      0x20000
#define BUFFER_SIZE     0x2000
#define HALF_SECOND     45000
#define ONE_SECOND      90000
#define FIVE_SECONDS    450000


//---------------------------------------------------------------------------
//#include <stdio.h>
//#include <stdlib.h>
#include <io.h>
#include <fcntl.h>
#include <math.h>
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;


// Global variabls

int audio_offset = 0;
int video_offset = 0;
int TestCount=0, glChunkCount;
bool init_parse_chunk;
HANDLE audio_out, video_out, stream_in;
unsigned long StreamSize;       // file length of TyStream file in megabytes
unsigned long MegsRead, SkipChunks;
static unsigned char buf[CHUNK_SIZE], buf2[CHUNK_SIZE], buf3[CHUNK_SIZE];
//TList   ChunkList;


    static unsigned char mpeg_end_code[4] = {0x00,0x00,0x01,0xB9};
    static unsigned char mpeg_pack_header[14] = {0x00, 0x00, 0x01, 0xBA, 0x44, 0x00, 0x04, 0x00, 0x0C,
                                                 0x01, 0x00, 0xB6, 0x93, 0xF8};
    static unsigned char mpeg_system_header[18] = {0x00, 0x00, 0x01, 0xBB, 0x00, 0x0C, 0x80, 0x37, 0x7F,
                                                   0x04, 0xE1, 0x7F, 0xE0, 0xE1, 0x02, 0xC0, 0xC0, 0x20};
    static unsigned char mpeg_pes_header[16] = {0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x8C, 0x80, 0x07,
                                                0x21, 0x00, 0x07, 0x54, 0x29, 0xFF, 0xFF};
    static unsigned char mpeg_notime_pes_header[9] = {0x00, 0x00, 0x01, 0xE0, 0x00, 0x00, 0x8C, 0x00, 0x00};
    static unsigned char mpeg_header[22] =

{
0x00, 0x00, 0x01, 0xE0, 0x07, 0xEC, 0x80, 0xC1,
0x0D, 0x31, 0x00, 0x03, 0x2B, 0x31, 0x11, 0x00,
0x03, 0x13, 0xBB, 0x1E, 0x60, 0x81
};



// function prototypes

static int parse_chunk(void);


//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ConvertBtnClick(TObject *Sender)
{
    int button, i, ChunkCount=0, num_recs, Offset, FirstTime, LastTime;
    bool GotFirst=false;
    DWORD size1, size2, BytesRead, BytesWritten, DistanceToMoveHigh;
    unsigned long timebase, program_mux_rate;


    // formula is ((data_rate*1024)/8)/50
    program_mux_rate=0x3A00;    // "best quality" data rate 5800.00 kbps
//    program_mux_rate=0x2300;    // "high quality" data rate 3500.00 kbps
//    program_mux_rate=0x1A00;    // "medium quality" data rate 2600.00 kbps
//    program_mux_rate=0x0EB3;    // "basic quality" data rate 1470.00 kbps

    // set program_mux_rate in pack header
    mpeg_pack_header[10]=(program_mux_rate>>14)&0xFF; mpeg_pack_header[11]=(program_mux_rate>>6)&0xFF; mpeg_pack_header[12]=((program_mux_rate<<2)|3)&0xFF;
    // set start time in pack header
    mpeg_pack_header[4]=0x44; mpeg_pack_header[5]=0x00; mpeg_pack_header[6]=0x04; mpeg_pack_header[7]=0x00; mpeg_pack_header[8]=0x0C;

    // set rate_bound in system header
    mpeg_system_header[6]=((program_mux_rate>>15)|0x80)&0xFF; mpeg_system_header[7]=(program_mux_rate>>7)&0xFF; mpeg_system_header[8]=((program_mux_rate<<1)|1)&0xFF;

    StatusBox->Items->Clear();

    stream_in=CreateFile(StreamFileEdit->Text.c_str(), GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
    if (stream_in==INVALID_HANDLE_VALUE)
    {
        StatusBox->Items->Add("Failed to open input file:");
        StatusBox->Items->Add(StreamFileEdit->Text);
        return;
    }

    size1=GetFileSize(stream_in, &size2);
    StreamSize = (size2<<12)|(size1>>20);
    MegsRead=0;
    ProgressBar1->Position=0;

    if (SeperateFilesBtn->Checked)
    {
        if (FileExists(AudioFileEdit->Text))
        {
            button = Application->MessageBox((AudioFileEdit->Text+" already exists.  Overwrite?").c_str(), "File exists", MB_OKCANCEL + MB_DEFBUTTON1);
            if (button == IDCANCEL) return;
        }

        audio_out=CreateFile(AudioFileEdit->Text.c_str(), GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, 0, NULL);
        if (audio_out==INVALID_HANDLE_VALUE)
        {
            StatusBox->Items->Add("Failed to open output file:");
            StatusBox->Items->Add(AudioFileEdit->Text);
            return;
        }
    }
    else
        audio_out=INVALID_HANDLE_VALUE;

    if (FileExists(VideoFileEdit->Text))
    {
        button = Application->MessageBox((VideoFileEdit->Text+" already exists.  Overwrite?").c_str(), "File exists", MB_OKCANCEL + MB_DEFBUTTON1);
        if (button == IDCANCEL) return;
    }
/*
    video_out=CreateNamedPipe(

    VideoFileEdit->Text.c_str(),	// pointer to pipe name
    PIPE_ACCESS_OUTBOUND,	// pipe open mode
    0,	// pipe-specific modes
    1,	// maximum number of instances
    2048*1024,	// output buffer size, in bytes
    2048*1024,	// input buffer size, in bytes
    10000,	// time-out time, in milliseconds
    NULL 	// pointer to security attributes structure
   );
*/
//   ConnectNamedPipe (video_out, NULL);
    video_out=CreateFile(VideoFileEdit->Text.c_str(), GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, 0, NULL);
    if (video_out==INVALID_HANDLE_VALUE)
    {
        StatusBox->Items->Add("Failed to open output file:");
        StatusBox->Items->Add(VideoFileEdit->Text);
        return;
    }

    if (ChunkCheck->Checked)
        SkipChunks=StrToInt(SkipEdit->Text);

    if (PercentCheck->Checked)
        SkipChunks=((double)StreamSize*((double)StrToInt(SkipEdit->Text)/100))*8;

    if (TimeCheck->Checked)
    {
        SkipChunks=StrToInt(SkipEdit->Text.SubString(SkipEdit->Text.Length()-1, 2))+
                StrToInt(SkipEdit->Text.SubString(1, SkipEdit->Text.Length()-3))*60;

        StatusBox->Items->Add("Skipping "+IntToStr(SkipChunks)+" seconds which is:");

        while ((ChunkCount/8) < StreamSize)

        {
            DistanceToMoveHigh=(ChunkCount*2)>>16;
            SetFilePointer(stream_in, (ChunkCount*2)<<16, (long *)&DistanceToMoveHigh, FILE_BEGIN);

            ReadFile(stream_in, buf, 4, &BytesRead, NULL);
            num_recs = (buf[1]<<8) | buf[0];

            ReadFile(stream_in, buf, num_recs*16, &BytesRead, NULL);

            Offset=0;
            for (i=0; i<num_recs; i++)
            {
                if ((buf[i*16 + 3] == AUDIO_ID) && ((buf[i*16 + 2]&0x0f) == AUDIO_PES))
                {
                    DistanceToMoveHigh=(ChunkCount*2)>>16;
                    SetFilePointer(stream_in, (ChunkCount*2)<<16, (long *)&DistanceToMoveHigh, FILE_BEGIN);
                    SetFilePointer(stream_in, 4 + num_recs*16 + Offset, NULL, FILE_CURRENT);

                    ReadFile(stream_in, buf, 16, &BytesRead, NULL);

                    timebase=((((((((buf[9]&0x06)<<7)|buf[10])<<7)|(buf[11]>>1))<<8)|buf[12])<<7)|(buf[13]>>1);

                    if (GotFirst==false)
                    {
                        GotFirst=true;
                        FirstTime=timebase/ONE_SECOND;
                        LastTime=timebase/ONE_SECOND;
                    }

                    break;
                }
                else
                {
                    if ((buf[i*16 + 3] == AUDIO_ID) || (buf[i*16 + 3] == VIDEO_ID))
                        Offset+=(((buf[i*16 + 0]<<8) | buf[i*16 + 1])<<4) | (buf[i*16 + 2]>>4);
                }
            }

            if ((GotFirst) && (labs((int)(timebase/ONE_SECOND) - LastTime) < 5))
            {
                LastTime=timebase/ONE_SECOND;

                if ((timebase/ONE_SECOND) >= (SkipChunks-FirstTime))
                {
                    SkipChunks=ChunkCount;
                    StatusBox->Items->Add(IntToStr(SkipChunks)+" chunks");
                    break;
                }
            }

            ChunkCount++;
        }
    }
    glChunkCount=SkipChunks;

    DistanceToMoveHigh=(SkipChunks*2)>>16;
    SetFilePointer(stream_in, (SkipChunks*2)<<16, (long *)&DistanceToMoveHigh, FILE_BEGIN);

    if (SingleFileBtn->Checked)
    {
        if (WriteFile(video_out, mpeg_pack_header, 14, &BytesWritten, NULL)==0)
        {
            Application->MessageBox("Error writing video file", "File error", MB_OK);
            return;
        }
        if (WriteFile(video_out, mpeg_system_header, 18, &BytesWritten, NULL)==0)
        {
            Application->MessageBox("Error writing video file", "File error", MB_OK);
            return;
        }
    }

    StatusBox->Items->Add("Converting file");

    ReadFile(stream_in, buf2, CHUNK_SIZE, &BytesRead, NULL);
    ReadFile(stream_in, buf3, CHUNK_SIZE, &BytesRead, NULL);
    glChunkCount++;

    init_parse_chunk=true;

    ConvertBtn->Enabled=false;
    AbortBtn->Enabled=true;
    PauseBtn->Enabled=true;
    Timer1->Enabled=true;
}
//---------------------------------------------------------------------------


static int parse_chunk(void)
{
    AnsiString    TempStr;
    unsigned int num_recs = (buf[1]<<8) | buf[0];
    unsigned int v_PacketLength, TypeNybble, WriteSize, WriteOfs, num_recs2, TempSize;
    static unsigned int type, ThisPacketSize, NextPacketSize, chunk_num;
    static unsigned char a_pes[16], last_a_pes[16], v_pes[16], last_v_pes[16];
    static unsigned char AudBuf[CHUNK_SIZE], VidBuf[CHUNK_SIZE*2];
    static unsigned long a_timebase, last_a_timebase, v_timebase, last_v_timebase, FirstTime, timebase;
    static bool FirstPES, ReorderTimecodes;
    static int a_SyncCount;
    static unsigned long VidBuf_size=0, AudBuf_size=0;
    unsigned long StartVidBuf_size=VidBuf_size, StartAudBuf_size=AudBuf_size;
    int i, i2, j, chksum, ret, SizeOffset, RecCount, ExitCount, CurrentBuffer;
    unsigned char *p, *RecordPointer;
    static unsigned char *v_pes_pointer;
    DWORD BytesWritten;
    int total_misc=0, total_av=0, Hours, Minutes, Seconds;
    long int ofs=0;
    int UnRecognized = 0; // future use
    static bool foundfirstframe, a_suspended, v_suspended;
    int StartingRecord = -1;
    int hCount = 0;

    unsigned char tfoo[16];
    int tofs=(0);


    if (init_parse_chunk)
    {
        chunk_num=0;
        init_parse_chunk=false;
        FirstPES=true; ReorderTimecodes=false;
        AudBuf_size=0; VidBuf_size=0;
        a_SyncCount=StrToInt(Form1->AudioOffsetEdit->Text);
        a_timebase=0; last_a_timebase=0;
        v_timebase=0; last_v_timebase=0;
        v_pes_pointer=NULL;
        ThisPacketSize=0; NextPacketSize=0;
        foundfirstframe = false; v_suspended=false;
        if (Form1->AudioSyncCheck->Checked) a_suspended=true; else a_suspended=(a_SyncCount!=0);
        memset(a_pes, 0, 16); memset(last_a_pes, 0, 16);
        memset(v_pes, 0, 16); memset(last_v_pes, 0, 16);
    }
    else
        chunk_num++;

    /* each 128k chunk starts with N 16 byte record headers that tell you
       what sorts of things are in the chunk */
    p = &buf[4];
    ofs = 4 + (num_recs<<4);


    // process the chunk
    for (i=0; i<num_recs; i++)
    {
        unsigned long size = (((p[0]<<8) | p[1])<<4) | (p[2]>>4);

        type = p[3];
        TypeNybble=(p[2]&0x0f);

        int k;


        if ((foundfirstframe==false) && (type == VIDEO_ID) && (TypeNybble==VIDEO_HEADER))
        {
            foundfirstframe=true;

            if (Form1->SingleFileBtn->Checked)
            {
//                memcpy(VidBuf+VidBuf_size, mpeg_pack_header, 14);
//                VidBuf_size+=14;

                v_pes_pointer=VidBuf+VidBuf_size;
                memcpy(VidBuf+VidBuf_size, mpeg_pes_header, 16);
                VidBuf_size+=16;
            }
        }

        if ((type == VIDEO_ID) || (type == AUDIO_ID))
        {
            int j = 0;
            SizeOffset=0;

            switch (type)
            {
                case AUDIO_ID:
                    if (foundfirstframe)
                    {
                      if (TypeNybble == AUDIO_PES)
                      {
                        memcpy(last_a_pes, a_pes, 16);
                        memcpy(a_pes, buf+ofs, 16);


                        if (FirstPES)
                        {
                            if (v_pes_pointer)
                            {
                                if (Form1->CorruptCheck->Checked)
                                {
                                    v_pes_pointer[4]=1; v_pes_pointer[5]=0;
                                }
                                else
                                {
                                    v_pes_pointer[4]=(VidBuf_size-6)>>8; v_pes_pointer[5]=(VidBuf_size-6)&0xFF;
                                }
                            }

                            FirstPES=false;
                            FirstTime=((((((((a_pes[9]&0x06)<<7)|a_pes[10])<<7)|(a_pes[11]>>1))<<8)|a_pes[12])<<7)|(a_pes[13]>>1);
                            if (FirstTime>FIVE_SECONDS) ReorderTimecodes=true;
                        }

                        last_a_timebase=a_timebase;
                        a_timebase=((((((((a_pes[9]&0x06)<<7)|a_pes[10])<<7)|(a_pes[11]>>1))<<8)|a_pes[12])<<7)|(a_pes[13]>>1);

                        if (ReorderTimecodes)
                        {
                            a_timebase=(HALF_SECOND+a_timebase)-FirstTime;

                            a_pes[13]=((a_timebase&0x7F)<<1)|1;
                            a_pes[12]=(a_timebase&0x7F80)>>7;
                            a_pes[11]=((a_timebase&0x3F8000)>>14)|1;
                            a_pes[10]=(a_timebase&0x3FC00000)>>22;
                            a_pes[9]=((a_timebase&0xC0000000)>>29)|0x21;
                        }


                        if ((last_a_timebase) && (labs(a_timebase-last_a_timebase) > ONE_SECOND) && (!Form1->DontSkipCheck->Checked))
                        {
                            Form1->StatusBox->Items->Add("aud: "+IntToHex((int)a_timebase, 8)+"!="+IntToHex((int)last_a_timebase, 8));
                            Form1->StatusBox->Items->Add("skipping chunk #"+IntToHex(glChunkCount, 8));
                            memcpy(a_pes, last_a_pes, 16);
                            a_timebase=last_a_timebase;
                            AudBuf_size=StartAudBuf_size; VidBuf_size=StartVidBuf_size;
                            return 0;   // Get outa here without writing the data we have so far
                        }

                        if ((last_a_timebase) && (a_timebase-last_a_timebase>7000))
                            Form1->StatusBox->Items->Add("Timecode jumps from "+IntToHex((int)a_timebase, 8)+" to "+IntToHex((int)last_a_timebase, 8));

                        // Try to synchronize audio and video
                        if (a_suspended)
                        {
                            if (Form1->AudioSyncCheck->Checked)
                            {
                                if ((long)a_timebase >= (long)v_timebase)
                                    a_suspended=false;
                            }
                            else
                            {
                                if (a_SyncCount==0) a_suspended=false; else a_SyncCount--;
                            }
                        }

                        if (a_suspended)
                            Form1->StatusBox->Items->Add("Discarding audio, timecode: "+IntToHex((int)a_timebase, 8));
                        else
                        {
//                            a_pes[6]=0x88;
                            if (Form1->SingleFileBtn->Checked)
                            {
/*
                                mpeg_pack_header[8]=a_pes[13]<<2;
                                mpeg_pack_header[7]=a_pes[12]<<2|a_pes[13]>>6;
                                mpeg_pack_header[6]=a_pes[11]<<2|a_pes[12]>>6;
                                mpeg_pack_header[5]=a_pes[10]<<2|a_pes[11]>>6;
                                mpeg_pack_header[4]=0x40|((a_pes[9]<<2)&0x0F)|a_pes[10]>>6;

                                memcpy(AudBuf+AudBuf_size, mpeg_pack_header, 14);
                                AudBuf_size+=14;
*/
                                memcpy(AudBuf+AudBuf_size, a_pes, 16);
                                AudBuf_size+=16;
                            }
                        }
                        Form1->TimebasePanel->Caption=IntToHex((int)a_timebase, 8);

                        Seconds=a_timebase/ONE_SECOND;
                        Minutes=Seconds/60;
                        Hours=Minutes/60;
                        Minutes-=Hours*60;
                        Seconds-=Minutes*60;
                        Form1->TimePanel->Caption=IntToStr(Hours)+":"+("0"+IntToStr(Minutes)).SubString((Minutes>9)+1, 2)+":"+("0"+IntToStr(Seconds)).SubString((Seconds>9)+1, 2);

                      }
                      else
                      {
                        if (!a_suspended)
                        {
                            memcpy(AudBuf+AudBuf_size, buf+(ofs), size);
                            AudBuf_size+=(size);
                        }
                      }
                    }
                    break;

                case VIDEO_ID:
                    if (foundfirstframe==true)
                    {
                      if (TypeNybble == VIDEO_PES)
                      {
                        // write out the old audio before dealing with this new video
                        if (AudBuf_size)
                        {
                            if (Form1->SeperateFilesBtn->Checked)
                            {
                                if (WriteFile(audio_out, AudBuf, AudBuf_size, &BytesWritten, NULL)==0)
                                {
                                    Application->MessageBox("Error writing audio file", "File error", MB_OK);
                                    return 1;
                                }
                            }
                            else
                            {
                                mpeg_pack_header[8]=a_pes[13]<<2;
                                mpeg_pack_header[7]=a_pes[12]<<2|a_pes[13]>>6;
                                mpeg_pack_header[6]=a_pes[11]<<2|a_pes[12]>>6;
                                mpeg_pack_header[5]=a_pes[10]<<2|a_pes[11]>>6;
                                mpeg_pack_header[4]=0x40|((a_pes[9]<<2)&0x0F)|a_pes[10]>>6;

                                memcpy(VidBuf+VidBuf_size, mpeg_pack_header, 14);
                                VidBuf_size+=14;

                                memcpy(VidBuf+VidBuf_size, AudBuf, AudBuf_size);
                                VidBuf_size+=AudBuf_size;
                            }
                            AudBuf_size=0;
                        }

                        memcpy(last_v_pes, v_pes, 16);
                        memcpy(v_pes, buf+ofs, 16);

                        if (FirstPES)
                        {
                            if (v_pes_pointer)
                            {
                                if (Form1->CorruptCheck->Checked)
                                {
                                    v_pes_pointer[4]=1; v_pes_pointer[5]=0;
                                }
                                else
                                {
                                    v_pes_pointer[4]=(VidBuf_size-6)>>8; v_pes_pointer[5]=(VidBuf_size-6)&0xFF;
                                }
                            }

                            FirstPES=false;

                            FirstTime=((((((((v_pes[9]&0x06)<<7)|v_pes[10])<<7)|(v_pes[11]>>1))<<8)|v_pes[12])<<7)|(v_pes[13]>>1);
                            if (FirstTime>FIVE_SECONDS) ReorderTimecodes=true;
                        }

                        last_v_timebase=v_timebase;
                        v_timebase=((((((((v_pes[9]&0x06)<<7)|v_pes[10])<<7)|(v_pes[11]>>1))<<8)|v_pes[12])<<7)|(v_pes[13]>>1);

                        if (ReorderTimecodes)
                        {
                            v_timebase=(HALF_SECOND+v_timebase)-FirstTime;

                            v_pes[13]=((v_timebase&0x7F)<<1)|1;
                            v_pes[12]=(v_timebase&0x7F80)>>7;
                            v_pes[11]=((v_timebase&0x3F8000)>>14)|1;
                            v_pes[10]=(v_timebase&0x3FC00000)>>22;
                            v_pes[9]=((v_timebase&0xC0000000)>>29)|0x21;
                        }

                        if ((last_v_timebase) && (labs(v_timebase-last_v_timebase) > ONE_SECOND) && (!Form1->DontSkipCheck->Checked))
                        {
                            Form1->StatusBox->Items->Add("vid: "+IntToHex((int)v_timebase, 8)+"!="+IntToHex((int)last_v_timebase, 8));
                            Form1->StatusBox->Items->Add("skipping chunk #"+IntToHex(glChunkCount, 8));
                            memcpy(v_pes, last_v_pes, 16);
                            v_timebase=last_v_timebase;
                            AudBuf_size=StartAudBuf_size; VidBuf_size=StartVidBuf_size;
                            return 0;   // Get outa here without writing the data we have so far
                        }

                        v_PacketLength=10; ExitCount=0;
                        RecCount=i+1;
                        RecordPointer=(buf+4+(RecCount*16));
                        CurrentBuffer=1;
                        num_recs2=num_recs;

                        // in case we need to wrap into the next 128K chunk
                        if (RecCount>=num_recs2)
                        {
                            RecCount=0;
                            num_recs2=(buf2[1]<<8) | buf2[0];
                            RecordPointer=(buf2+4);
                            CurrentBuffer=2;
                        }

                        while (!((RecordPointer[2]==0x06) && (RecordPointer[3]==0xE0)))  // While not V-PES
                        {
                            // if it's video, total in it's size
//                            if ((RecordPointer[3]==0xC0) || (RecordPointer[3]==0xE0))
                            if ((RecordPointer[3]==0xE0) /*&& (RecordPointer[2]!=0x8C)*/)
//                            if ((RecordPointer[3]==0xE0) && (RecordPointer[2]!=0x8C))
                                v_PacketLength+=(((RecordPointer[0]<<8) | RecordPointer[1])<<4) | (RecordPointer[2]>>4);

                            RecCount++;
                            RecordPointer+=16;

                            // in case we need to wrap into the next 128K chunk
                            if (RecCount>=num_recs2)
                            {
                                CurrentBuffer++;
                                if (CurrentBuffer>3)
                                {
                                    Form1->StatusBox->Items->Add("Couldn't find video PES in chunk "+IntToStr(chunk_num));
                                    AudBuf_size=0;
                                    return 0;  // Something went wrong
                                }

                                RecCount=0;

                                if (CurrentBuffer==2)
                                {
                                  num_recs2=(buf2[1]<<8) | buf2[0];
                                  RecordPointer=(buf2+4);
                                }
                                else
                                {
                                  num_recs2=(buf3[1]<<8) | buf3[0];
                                  RecordPointer=(buf3+4);
                                }
                            }
                        }

//                        v_pes[6]=0x88;

                        if (v_PacketLength>0xFFFE)
                        {
                            ThisPacketSize=0xFFFE;
                            NextPacketSize=v_PacketLength-0xFFFE;
//                            Form1->StatusBox->Items->Add("Long:"+IntToStr(v_PacketLength)+" this:"+IntToStr(ThisPacketSize)+" next:"+IntToStr(NextPacketSize));
                        }
                        else
                        {
                            ThisPacketSize=v_PacketLength;
                            NextPacketSize=0;
                        }

                        v_pes[5]=ThisPacketSize&0xFF;
                        v_pes[4]=(ThisPacketSize&0xFF00)>>8;

                        ThisPacketSize-=10;


                        if (WriteFile(video_out, VidBuf, VidBuf_size, &BytesWritten, NULL)==0)
                        {
                            Application->MessageBox("Error writing video file", "File error", MB_OK);
                            return 1;
                        }

                        VidBuf_size=0;

                        if (Form1->SingleFileBtn->Checked)
                        {
/*
                            mpeg_pack_header[8]=v_pes[13]<<2;
                            mpeg_pack_header[7]=v_pes[12]<<2|v_pes[13]>>6;
                            mpeg_pack_header[6]=v_pes[11]<<2|v_pes[12]>>6;
                            mpeg_pack_header[5]=v_pes[10]<<2|v_pes[11]>>6;
                            mpeg_pack_header[4]=0x40|((v_pes[9]<<2)&0x0F)|v_pes[10]>>6;

                            memcpy(VidBuf+VidBuf_size, mpeg_pack_header, 14);
                            VidBuf_size+=14;
*/
                            v_pes_pointer=VidBuf+VidBuf_size;
                            memcpy(VidBuf+VidBuf_size, v_pes, 16);
                            VidBuf_size+=16;
                        }

                      }
                      else
                      {
                        // Remove 1, 2 or 3 leading zeros from video header
                        if (TypeNybble==VIDEO_HEADER)
                        {
                            for (i2=0; i2<4; i2++)
                            {
                                if ((buf[ofs+SizeOffset]==0) && (buf[ofs+SizeOffset+1]==0) &&
                                        (buf[ofs+SizeOffset+2]==1) && (buf[ofs+SizeOffset+3]==0xB3))
                                    break;

                                SizeOffset++;
                            }
                        }
                        // Adjust packet size stored in PES Header to compensate for deleted bytes
                        if ((SizeOffset) && (v_pes_pointer))
                        {
                            TempSize=((v_pes_pointer[4]<<8)|v_pes_pointer[5])-SizeOffset;
                            v_pes_pointer[4]=TempSize>>8; v_pes_pointer[5]=TempSize&0xFF;
                        }
                        size-=SizeOffset;
                        ofs+=SizeOffset;
                        ThisPacketSize-=SizeOffset;

                        if ((!v_suspended)/* && (TypeNybble!=0x0C)*/)
//                        if ((!v_suspended) && (TypeNybble!=0x0C))
                        {

                            WriteSize=size; WriteOfs=0;

                            while (WriteSize)
                            {
                                if (WriteSize>ThisPacketSize+NextPacketSize)    // This shouldn't happen (usually)
                                {
                                    memcpy(VidBuf+VidBuf_size, buf+ofs, WriteSize);
                                    VidBuf_size+=WriteSize;

                                    ThisPacketSize=0; NextPacketSize=0;
                                    WriteSize=0;
                                    break;
                                }

                                if (WriteSize<ThisPacketSize)
                                {
                                    memcpy(VidBuf+VidBuf_size, buf+ofs+WriteOfs, WriteSize);
                                    VidBuf_size+=WriteSize;

                                    ThisPacketSize-=WriteSize;
                                    WriteSize=0;
                                }
                                else
                                {
                                    memcpy(VidBuf+VidBuf_size, buf+ofs+WriteOfs, ThisPacketSize);
                                    VidBuf_size+=ThisPacketSize;

                                    WriteSize-=ThisPacketSize;
                                    WriteOfs+=ThisPacketSize;

                                    if (NextPacketSize>0xFFF4)
                                        ThisPacketSize=0xFFF4;
                                    else
                                        ThisPacketSize=NextPacketSize;

                                    NextPacketSize-=ThisPacketSize;

                                    if (ThisPacketSize)
                                    {
                                        v_pes[5]=(ThisPacketSize+3)&0xFF;
                                        v_pes[4]=((ThisPacketSize+3)&0xFF00)>>8;

                                        if (Form1->SingleFileBtn->Checked)
                                        {
//                                            memcpy(VidBuf+VidBuf_size, v_pes, 16);
//                                            VidBuf_size+=16;
                                            memcpy(mpeg_notime_pes_header+4, v_pes+4, 2);
                                            memcpy(VidBuf+VidBuf_size, mpeg_notime_pes_header, 9);
                                            VidBuf_size+=9;
                                        }
                                    }

                                }
                            }
                        }

                      }
                    }
                    break;
            }

            ofs += size;
        }
        p += 16;

    }

    return 0;
}


void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
    static int ChunkCount=0;
    unsigned long index, i, Offset, timebase;
    static unsigned long last_a_timebase, last_v_timebase;
    DWORD BytesRead, BytesWritten;
    int n, ProgPos, num_recs, Skipped;


    if (init_parse_chunk)
    {
        last_a_timebase=0, last_v_timebase=0;
    }


    memcpy(buf, buf2, CHUNK_SIZE);  // we look ahead two chunks while reading
    memcpy(buf2, buf3, CHUNK_SIZE);

    // if the chunk has the wrong timecode, get another until it's right
    Skipped=0;
    do
    {
        ReadFile(stream_in, buf3, CHUNK_SIZE, &BytesRead, NULL);
        glChunkCount++;

        num_recs = (buf3[1]<<8) | buf3[0];

        // Make sure this is the right chunk
        Offset=4 + (num_recs<<4);
        for (i=0; i<num_recs; i++)
        {
            if ((buf3[i*16 +3+4] == AUDIO_ID) && ((buf3[i*16 +2+4]&0x0f) == AUDIO_PES))
            {
                timebase=((((((((buf3[Offset+9]&0x06)<<7)|buf3[Offset+10])<<7)|(buf3[Offset+11]>>1))<<8)|
                        buf3[Offset+12])<<7)|(buf3[Offset+13]>>1);

                if ((last_a_timebase) && (labs(timebase-last_a_timebase) > ONE_SECOND) && (!Form1->DontSkipCheck->Checked))
                {
                    Form1->StatusBox->Items->Add("aud: "+IntToHex((int)timebase, 8)+" != "+IntToHex((int)last_a_timebase, 8));
                    Form1->StatusBox->Items->Add("skipping chunk #"+IntToHex(glChunkCount, 8));
                    Skipped++;
                    i=num_recs+1;
                    continue;
                }
                else
                {
                    last_a_timebase=timebase;
                }
            }

            if ((buf3[i*16 +3+4] == VIDEO_ID) && ((buf3[i*16 +2+4]&0x0f) == VIDEO_PES))
            {
                timebase=((((((((buf3[Offset+9]&0x06)<<7)|buf3[Offset+10])<<7)|(buf3[Offset+11]>>1))<<8)|
                        buf3[Offset+12])<<7)|(buf3[Offset+13]>>1);

                if ((last_v_timebase) && (labs(timebase-last_v_timebase) > ONE_SECOND) && (!Form1->DontSkipCheck->Checked))
                {
                    Form1->StatusBox->Items->Add("vid: "+IntToHex((int)timebase, 8)+" != "+IntToHex((int)last_v_timebase, 8));
                    Form1->StatusBox->Items->Add("skipping chunk #"+IntToHex(glChunkCount, 8));
                    Skipped++;
                    i=num_recs+1;
                    continue;
                }
                {
                    last_v_timebase=timebase;
                }
            }

            if ((buf3[i*16 +3+4] == AUDIO_ID) || (buf3[i*16 +3+4] == VIDEO_ID))
                Offset+=(((buf3[i*16 + 4]<<8) | buf3[i*16 +1+4])<<4) | (buf3[i*16 +2+4]>>4);
        }
        if (i<=num_recs) break;
    } while (Skipped<30);


    if ((BytesRead==0) || (Skipped>=30))
    {
      Timer1->Enabled=false;
      ConvertBtn->Enabled=true;
      AbortBtn->Enabled=false;
      PauseBtn->Enabled=false;

      if (SingleFileBtn) WriteFile(video_out, mpeg_end_code, 4, &BytesWritten, NULL);

      CloseHandle(stream_in);
      if (audio_out!=INVALID_HANDLE_VALUE) CloseHandle(audio_out);
      CloseHandle(video_out);

      ProgressLabel->Caption="100%";
      ProgressBar1->Position=100;

      StatusBox->Items->Add("Done.");

      return;
    }

    if (parse_chunk())
    {
      Timer1->Enabled=false;
      ConvertBtn->Enabled=true;
      AbortBtn->Enabled=false;
      PauseBtn->Enabled=false;

      CloseHandle(stream_in);
      if (audio_out!=INVALID_HANDLE_VALUE) CloseHandle(audio_out);
      CloseHandle(video_out);
   }

    ChunkCount++;
    if (ChunkCount>8)
    {
        ChunkCount=0;
        MegsRead++;

        if (MSProgCheck->Checked)
        {
            ProgPos=((double)(MegsRead + SkipChunks/8)/(double)StreamSize)*1000;
            if (ProgPos>990)
                ProgPos=100;
            else if (ProgPos>99) ProgPos=99;
        }
        else
            ProgPos=((double)(MegsRead + SkipChunks/8)/(double)StreamSize)*100;

        ProgressLabel->Caption=IntToStr(ProgPos)+"%";
        ProgressBar1->Position=ProgPos;
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::AbortBtnClick(TObject *Sender)
{
    DWORD BytesWritten;
    int i;

    if (AbortBtn->Enabled)
    {
      Timer1->Enabled=false;

      if (SingleFileBtn) WriteFile(video_out, mpeg_end_code, 4, &BytesWritten, NULL);

      ConvertBtn->Enabled=true;
      AbortBtn->Enabled=false;
      PauseBtn->Caption="Pause";
      PauseBtn->Enabled=false;

      CloseHandle(stream_in);
      if (audio_out!=INVALID_HANDLE_VALUE) CloseHandle(audio_out);
      CloseHandle(video_out);
    }
}
//---------------------------------------------------------------------------


void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
    AbortBtnClick(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PauseBtnClick(TObject *Sender)
{
    if (Timer1->Enabled)
    {
        Timer1->Enabled=false;
        PauseBtn->Caption="Resume";
    }
    else
    {
        Timer1->Enabled=true;
        PauseBtn->Caption="Pause";
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::AudioSyncCheckClick(TObject *Sender)
{
    AudioOffsetEdit->Enabled=!AudioSyncCheck->Checked;

    if (SingleFileBtn->Checked && AudioSyncCheck->Checked) Application->MessageBox("This feature was intended to be used with 'seperate files' mode, but I'll try to do it anyway.",
                    "Incorrect use of feature", MB_OK);

}
//---------------------------------------------------------------------------


void __fastcall TForm1::SingleFileBtnClick(TObject *Sender)
{
    AudioFileLabel->Visible=SeperateFilesBtn->Checked;
    AudioFileEdit->Visible=SeperateFilesBtn->Checked;
/*    AudioSyncCheck->Visible=SeperateFilesBtn->Checked;
    ManualAudioLabel->Visible=SeperateFilesBtn->Checked;
    AudioOffsetEdit->Visible=SeperateFilesBtn->Checked;*/
    if (SeperateFilesBtn->Checked)
    {
        VideoFileLabel->Caption="Video MPEG filename";

        Application->MessageBox("By choosing to split the streams, you will be discarding the timecodes that keep audio and video synchronized.  Good luck!",
                    "Warning", MB_OK);
    }
    else
        VideoFileLabel->Caption="MPEG filename";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TimeCheckClick(TObject *Sender)
{
    if (SkipEdit->Text.AnsiPos(":")==0) SkipEdit->Text="0:00";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PercentCheckClick(TObject *Sender)
{
    if (SkipEdit->Text.AnsiPos(":")) SkipEdit->Text="0";
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ChunkCheckClick(TObject *Sender)
{
    if (SkipEdit->Text.AnsiPos(":")) SkipEdit->Text="0";
}
//---------------------------------------------------------------------------






void __fastcall TForm1::Button1Click(TObject *Sender)
{
    HANDLE video_out, stream_in;
    DWORD BytesRead, BytesWritten, DistanceToMoveHigh;
    int i;


    stream_in=CreateFile(StreamFileEdit->Text.c_str(), GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
    video_out=CreateFile(VideoFileEdit->Text.c_str(), GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, CREATE_ALWAYS, 0, NULL);

    for (i=0; i<150; i++)
    {
        ReadFile(stream_in, buf, CHUNK_SIZE, &BytesRead, NULL);
        WriteFile(video_out, buf, CHUNK_SIZE, &BytesWritten, NULL);
    }

    CloseHandle(stream_in);
    CloseHandle(video_out);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender)
{
    HANDLE video_out, stream_in;
    DWORD BytesRead=1, BytesWritten, DistanceToMoveHigh;
    int i, offset=0;


    stream_in=CreateFile(StreamFileEdit->Text.c_str(), GENERIC_READ, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL);
    if (stream_in==INVALID_HANDLE_VALUE)
    {
        StatusBox->Items->Add("Failed to open input file:");
        StatusBox->Items->Add(StreamFileEdit->Text);
        return;
    }

    while (BytesRead)
    {
        ReadFile(stream_in, buf, 1, &BytesRead, NULL); offset++;
        if (buf[0]!=0) continue;
        else
          ReadFile(stream_in, buf, 1, &BytesRead, NULL); offset++;
          if (buf[0]!=0) continue;
          else
            ReadFile(stream_in, buf, 1, &BytesRead, NULL); offset++;
            if (buf[0]!=1) continue;
            else
            {
                ReadFile(stream_in, buf, 1, &BytesRead, NULL); offset++;
                if ((buf[0]==0xE0) || (buf[0]==0xC0))
                {
                    ReadFile(stream_in, buf+1, 2, &BytesRead, NULL); offset+=2;

                    SetFilePointer(stream_in, buf[1]*256 + buf[2], NULL, FILE_CURRENT);

                    continue;
                }
                if (buf[0]==0xBA)
                {
                    ReadFile(stream_in, buf+3, 10, &BytesRead, NULL); offset+=10;
                    continue;
                }

                if (buf[0]==0xBB)
                {
                    ReadFile(stream_in, buf+3, 14, &BytesRead, NULL); offset+=14;
                    continue;
                }
                if (buf[0]!=0xB9)
                {
                    StatusBox->Items->Add("I don't understand "+IntToHex(buf[0], 2));
                    StatusBox->Items->Add("at byte "+IntToHex(offset, 8));

                    break;
                }
            }
        StatusBox->Items->Add("No errors found.");
    }

    CloseHandle(stream_in);

    StatusBox->Items->Add("Done.");
}
//---------------------------------------------------------------------------

